/*
 ============================================================================
 Name        : Project_client.c
 Author      : Tyler Mironuck
 Version     :
 Copyright   : Your copyright notice
 Description : Hello World in C, Ansi-style
 ============================================================================
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <pthread.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <semaphore.h>

#define MSG_SIZE 40			// message size

struct timeval TimeOfPress;
struct timeval YellowLightBegin;
struct timeval YellowLightEnd;
double time_of_press[1000000];
double light_begin;
double light_end;

struct sockaddr_in anybody, from;
int sock, n;
unsigned int length;
socklen_t fromlen;
int num_of_wins = 0;
int misses = 0;
char num_wins[20], num_miss[20];
char buffer[MSG_SIZE];	// to store received messages or messages to be sent.
char userInput[MSG_SIZE];	//to store user input from keyboard

int i;
volatile int quitFlag = 0;
volatile int pauseFlag = 0;

sem_t sem1;		//declar semaphore

void *RecieveMessageFromServer(void *arguments){
	int level = 1;
	int fd, fd_fifo_out;
	unsigned long *startPtr, *VIC2SoftInt;
	//open /dev/mem file to map the areas of physical address space into process user address space
	fd = open("/dev/mem", O_RDWR | O_SYNC);
	//set startPtr to VIC2 Base Address: 0x800C0000
	startPtr = mmap(NULL, getpagesize(), PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0x800C0000);
	VIC2SoftInt = (unsigned long *) ((char *) startPtr + 0x18);		//offset to VIC2SoftInt
	fd_fifo_out = open("/dev/rtf/3", O_RDWR);		//To access fifo 3

	write(fd_fifo_out, &level, sizeof(level));	//write to fifo 3 that was created in the kernel module
	*VIC2SoftInt |= 0x80000000;				//Trigger software interrupt in user space

	while(quitFlag == 0){
		char difficulty[30], comment[100];
	// receive message
		n = recvfrom(sock, buffer, MSG_SIZE, 0, (struct sockaddr *)&from, &length);
		if (n < 0)
			error("recvfrom");
		if(strncmp(buffer,"LEVEL2",6) == 0){ //if message is LEVEL2, change frequency to level 2
			level = 2;
			strcpy(difficulty, "NORMAL");
			strcpy(comment,"LIGHTS ARE CHANGING MORE RAPIDLY");
			printf("                            YOUR SCORE: %d\n\n\n\n", num_of_wins*100);
		}
		if(strncmp(buffer,"LEVEL3",6) == 0){ //if message is LEVEL3, change frequency to level 3
			level = 3;
			strcpy(difficulty, "HARD");
			strcpy(comment,"LIGHTS ARE CHANGING VERY FAST");
			printf("                            YOUR SCORE: %d\n\n\n\n", num_of_wins*100);
		}
		if(strncmp(buffer,"LEVEL4",6) == 0){ //if message is LEVEL4, change frequency to level 4
			level = 4;
			strcpy(difficulty, "VERY HARD");
			strcpy(comment,"LIGHTS ARE CHANGING EXTREMELY FAST");
			printf("                            YOUR SCORE: %d\n\n\n\n", num_of_wins*100);
		}
		if(strncmp(buffer,"LEVEL5",6) == 0){ //if message is LEVEL5, change frequency to level 5
			level = 5;
			strcpy(difficulty, "INTENSE");
			strcpy(comment,"GOOD LUCK!");
			printf("                            YOUR SCORE: %d\n\n\n\n", num_of_wins*100);
		}
		if(strncmp(buffer,"END",2) == 0){ //if message is LEVEL6, USER HAS BEAT THE GAME
			printf("\n                           CONGRATULATIONS!!!\n\n                      YOU HAVE BEATEN THE GAME!!!!!\n\n"
					"                    YOU SIR, HAVE NINJA LIKE REFLEXES\n\n\n");
			printf("                            YOUR SCORE: %d\n\n\n\n", num_of_wins*100);
			quitFlag = 1;
			pauseFlag = 0;
		}
		write(fd_fifo_out, &level, sizeof(level));	//write to fifo 3 that was created in the kernel module
		*VIC2SoftInt |= 0x80000000;				//Trigger software interrupt in user space
		if(quitFlag != 1){
			printf("WOULD YOU LIKE TO PROCEED TO LEVEL %d ? ", level);
			fgets(userInput, MSG_SIZE, stdin);
			while( strncmp(userInput,"YES",3) && strncmp(userInput, "yes", 3) && strncmp(userInput,"NO",2) && strncmp(userInput, "no", 2)){
					printf("Please enter \"YES\" or \"NO\"\n");
					fgets(userInput, MSG_SIZE, stdin);
			}
			if( !strncmp(userInput,"YES",3) || !strncmp(userInput, "yes", 3) ){
				pauseFlag = 0;
				printf("\n\n====================================LEVEL %d====================================\n", level);
				printf("DIFFICULTY: %s - (%s)\n", difficulty, comment);
				printf("START LEVEL %d...\n", level);
				printf("TRY TO HIT BUTTON ON YELLOW!\n");
			}
			else if(!strncmp(userInput,"NO",2) || !strncmp(userInput, "no", 2)){
				quitFlag = 1;
				pauseFlag = 0;
				printf("\n\n\n                            YOUR SCORE: %d\n\n", num_of_wins*100);
				printf("                         THANK YOU FOR PLAYING");
				printf("\n\n\n\n\n\n");

				//printf("been here..quitFlag = %d, pauseFlag = %d\n", quitFlag, pauseFlag);
			}
		}
		//printf("Received something: %s\n", buffer);
	}
	pthread_exit(0);
}


void *RecieveLightTimes(void *arguments){
	int fd_fifo_in = open("/dev/rtf/0", O_RDWR);
	int fd_fifo_in1 = open("/dev/rtf/1", O_RDWR);
	int fd_fifo_in2 = open("/dev/rtf/2", O_RDWR);
	i = 0;
	int a;
	while(quitFlag == 0){
			//read in timestamp of when button was pressed
			read(fd_fifo_in, &TimeOfPress, sizeof(TimeOfPress));
			//Convert timestamp to all seconds and store in time_of_press
			time_of_press[i] = (TimeOfPress.tv_sec)  + (TimeOfPress.tv_usec/1000000.0);
			//printf("time of press in seconds: %f\n", time_of_press);
			//read in timestamp of when yellow light began
			read(fd_fifo_in1, &YellowLightBegin, sizeof(YellowLightBegin));
			//convert timestamp to seconds
			light_begin = (YellowLightBegin.tv_sec)  + (YellowLightBegin.tv_usec/1000000.0);
			do{
				//read in timestamp of when yellow light ended
				read(fd_fifo_in2, &YellowLightEnd, sizeof(YellowLightEnd));
				light_end = (YellowLightEnd.tv_sec)  + (YellowLightEnd.tv_usec/1000000.0);

				//printf("In loop\n");
			}while(light_end < light_begin);		//keep looping and reading timestamp until until end
													//of light timestap is larger than beginngin of light timestamp
			//printf("Time between presses: %f\n", time_of_press[i] - time_of_press[i-1]);

			if( (time_of_press[i] > light_begin) && (time_of_press[i] < light_end) ){ //If player hit the button during the interval
				if( i != 0  && (time_of_press[i] - time_of_press[i-1] < 3) ){		//Install a period of 3 seconds between button presses
					printf("You can't hit the button repeatedly. That is cheating!!\n");
				}
				else{
					//Player hit the button in the interval that the yellow light was on
					printf("\n\n                          HURRAY!!! YOU DID IT!!!\n\n\n\n");
					num_of_wins++;
					sprintf(num_wins,"$%d", num_of_wins);	//build a string that holds number of wins
						//broadcast number of wins to everyone so that server can read it
						n = sendto(sock, num_wins, strlen(num_wins), 0,
											(const struct sockaddr *)&anybody, length);
						if(n < 0)
							error("sendto");
						//Make thread pause until ReceiveMessageFromServer thread determines if player continued
						//on to the next level
						pauseFlag = 1;
					while(pauseFlag == 1){
						usleep(250000);
					}

				}
			}
			else{
				//record misses
				misses++;
					sprintf(num_miss,"@ %d", misses);	//build a string that holds number of misses
						//broadcast number of misses to everyone so that server can read it
						n = sendto(sock, num_miss, strlen(num_miss), 0,
															(const struct sockaddr *)&anybody, length);
										if(n < 0)
											error("sendto");
			}

			i++;
	}
	pthread_exit(0);

}

void error(const char *msg)
{
    perror(msg);
    exit(0);
}


int main(int argc, char *argv[])
{
	int boolval = 1;			// for a socket option
	char hostname[128], IP_Address[15], IP_Address_token[15];
	char *received_IP;
	char game_id[20];
	int i;
	int my_ip_last_digit, recvd_ip_last_digit;
	int bufTemp[2];
	char gameStatus[5];

	if (argc < 2)
	   {
		  printf("usage: %s port\n", argv[0]);
	      exit(0);
	   }

	gethostname(hostname, sizeof hostname);	//Retrieve local hostname of computer
	printf("My hostname: %s\n", hostname);	//Display hostname
	struct hostent *hstnm = gethostbyname(hostname);
	//Copy ip address into IP_address buffer in the
	/*The inet_ntoa function converts an ipv4 internet network address into an ASCII string in internet
	* standard dotted-decimal format as in the example "192.168.16.0".
	* h_addr is the member of struct hostent that holds the host address
	*/
	strcpy(IP_Address, inet_ntoa(*((struct in_addr*)hstnm->h_addr)));	//Copy ip address into IP_Address array
	printf("My IP address is: %s\n", IP_Address);
	strcpy(IP_Address_token, IP_Address);

	strtok(IP_Address_token, ".");
	for(i=0; i<3; i++){
		   my_ip_last_digit = atoi(strtok(NULL,"."));
	}

	sock = socket(AF_INET, SOCK_DGRAM, 0); // Creates socket. Connectionless.
	if (sock < 0)
		error("Opening socket");

	// change socket permissions to allow broadcast
	if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &boolval, sizeof(boolval)) < 0)
	{
		printf("error setting socket options\n");
		exit(-1);
	}

	anybody.sin_family = AF_INET;		// symbol constant for Internet domain
	anybody.sin_port = htons(atoi(argv[1]));				// port field
	anybody.sin_addr.s_addr = inet_addr("10.3.52.255");	// broadcast address

	length = sizeof(struct sockaddr_in);		// size of structure

	printf("\n");
	while(1){
		quitFlag = 0;
		printf("Would you like to play? YES or NO? ");
		fgets(userInput, MSG_SIZE, stdin);
		if( strncmp(userInput,"YES",3) && strncmp(userInput, "yes", 3) && strncmp(userInput,"NO",2) && strncmp(userInput, "no", 2)){
			printf("Please enter \"YES\" or \"NO\"\n");
		}

		if( !strncmp(userInput,"YES",3) || !strncmp(userInput, "yes", 3) ){
			strcpy(gameStatus, "#1");
			sprintf(game_id,"# %s",IP_Address);		//build a string that holds the game ID info
			printf("\n\n====================================LEVEL 1====================================\n");
			printf("DIFFICULTY: EASY - (LIGHTS ARE CHANGING SLOWLY)\n");
			printf("START GAME...\n");
			printf("TRY TO HIT BUTTON ON YELLOW!\n");
			//printf("%s\n", game_id);
			//Send message to anyone there...
			n = sendto(sock, gameStatus, strlen(gameStatus), 0,
			    	      	(const struct sockaddr *)&anybody, length);	//send game status to client program
				if(n < 0)
			    		   error("sendto");

			pthread_t thread1, thread2;					//Declare thread1 and thread2 variables of type pthread_t
			pthread_create(&thread1, NULL, RecieveLightTimes, NULL);
			pthread_create(&thread2, NULL, RecieveMessageFromServer, NULL);


			pthread_join(thread1, NULL);				//Wait for thread to finish
			pthread_join(thread2, NULL);				//Wait for thread to finish
		}
		strcpy(gameStatus, "#0");
		n = sendto(sock, gameStatus, strlen(gameStatus), 0,
					    	(const struct sockaddr *)&anybody, length);	//send game status to client program
				if(n < 0)
						   error("sendto");
	}


	close(sock);
	return 0;
}



